/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.QDStdUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

class QDEditButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private Border m_normalBorder;
    private Border m_pressedBorder;
    private Boolean m_pressing = false;
    private boolean m_mouseOver = false;
    private boolean m_isTight = true;

    public QDEditButton() {
        this.initLook();
    }

    public void setTightBorder(boolean bl) {
        if (bl == this.m_isTight) {
            return;
        }
        this.m_isTight = bl;
        Border border = BorderFactory.createEtchedBorder(QDStdUI.getHighlight(), QDStdUI.getShadow());
        Border border2 = BorderFactory.createEtchedBorder(QDStdUI.getShadow(), QDStdUI.getHighlight());
        if (this.m_isTight) {
            this.m_normalBorder = border;
            this.m_pressedBorder = border2;
        } else {
            Border border3 = BorderFactory.createEmptyBorder(3, 5, 3, 5);
            this.m_normalBorder = BorderFactory.createCompoundBorder(border, border3);
            this.m_pressedBorder = BorderFactory.createCompoundBorder(border2, border3);
        }
    }

    private void initLook() {
        this.setFont(QDStdUI.getActionFont());
        this.setForeground(QDStdUI.getActionForeground());
        this.setBackground(QDStdUI.getActionBackground());
        this.setMargin(QDStdUI.getActionInsets());
        this.setBorderPainted(true);
        this.setFocusable(true);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setTightBorder(false);
        this.setBorder(this.m_normalBorder);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                QDEditButton.this.m_pressing = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                QDEditButton.this.m_pressing = false;
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                QDEditButton.this.m_mouseOver = true;
                QDEditButton.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                QDEditButton.this.m_mouseOver = false;
                QDEditButton.this.repaint();
            }
        });
    }

    public void paint(Graphics graphics) {
        GradientPaint gradientPaint;
        if (this.m_pressing.booleanValue()) {
            if (this.m_mouseOver) {
                this.setBorder(this.m_pressedBorder);
            } else {
                this.setBorder(this.m_normalBorder);
            }
            graphics.setColor(Color.lightGray);
            this.setForeground(Color.BLACK);
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonDark(), 0.0f, this.getHeight(), QDStdUI.getButtonLight());
        } else {
            this.setBorder(this.m_normalBorder);
            if (this.m_mouseOver) {
                this.setForeground(QDStdUI.getFocusColor());
            } else {
                this.setForeground(Color.BLACK);
            }
            graphics.setColor(QDStdUI.getActionBackground());
            gradientPaint = new GradientPaint(0.0f, 0.0f, QDStdUI.getButtonLight(), 0.0f, this.getHeight(), QDStdUI.getButtonDark());
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setPaint(paint);
        if (this.isFocusOwner() && !this.m_pressing.booleanValue()) {
            Color color = this.m_pressing != false ? Color.black : QDStdUI.getFocusColor();
            graphics.setColor(color);
            graphics.drawRect(4, 4, this.getWidth() - 8, this.getHeight() - 8);
        }
        super.paint(graphics);
    }
}

